// Wiersz 71
jQuery = function( selector, context ) {

	// Obiekt jQuery to właściwie tylko rozszerzony konstruktor init
	// Konstruktor init jest wymagany w wypadku wywołania biblioteki jQuery (jeśli jej nie dołączono, należy jedynie 
	// umożliwić zgłoszenie błędu)
	return new jQuery.fn.init( selector, context );
};

// Wiersz 733
function Sizzle( selector, context, results, seed ) { /* ... */ }
// Wiersz 2678
jQuery.find = Sizzle;
// Wiersz 2769
jQuery.fn.extend( {
	find: function( selector ) {
		var i,
			len = this.length,
			ret = [],
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		// Wymagane, ponieważ $( selector, context ) staje się $( context ).find( selector )
		ret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );
		ret.selector = this.selector ? this.selector + " " + selector : selector;
		return ret;
	}
} );

// Wiersz 2822
// Prosty sposób sprawdzania łańcuchów HTML
// Określanie priorytetu dla #id za pomocą <tag> w celu uniknięcia ataku XSS za pośrednictwem location.hash (#9521)
// Ścisłe rozpoznawanie danych HTML (#11290: musi rozpoczynać się od znaku <)
rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,

init = jQuery.fn.init = function( selector, context, root ) {
	var match, elem;

	// UCHWYT: $(""), $(null), $(undefined), $(false)
	if ( !selector ) {
		return this;
	}

	// Metoda init() akceptuje alternatywny parametr rootjQuery,
	// dlatego może obsługiwać jQuery.sub (gh-2101)
	root = root || rootjQuery;

	// Obsługa łańcuchów HTML
	if ( typeof selector === "string" ) {
		if ( selector[ 0 ] === "<" &&
			selector[ selector.length - 1 ] === ">" &&
			selector.length >= 3 ) {

			// Przyjęto, że łańcuchy zaczynające się i kończące znakami <> to kod HTML, a ponadto
			// pominięto sprawdzanie wyrażenia regularnego
			match = [ null, selector, null ];

		} else {
			match = rquickExpr.exec( selector );
		}

		// Dopasowanie kodu HTML lub sprawdzenie, czy nie określono żadnego kontekstu dla #id
		if ( match && ( match[ 1 ] || !context ) ) {

			// UCHWYT: $(html) -> $(array)
			if ( match[ 1 ] ) {
				context = context instanceof jQuery ? context[ 0 ] : context;

				// Opcja uruchamiania skryptów ma wartość true w celu zapewnienia zgodności wstecz
				// Celowo umożliwiono zgłoszenie błędu w wypadku braku parseHTML
				jQuery.merge( this, jQuery.parseHTML(
					match[ 1 ],
					context && context.nodeType ? context.ownerDocument || context : document,
					true
				) );

				// UCHWYT: $(html, props)
				if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
					for ( match in context ) {

						// Jeśli to możliwe, właściwości kontekstu są wywoływane jako metody
						if ( jQuery.isFunction( this[ match ] ) ) {
							this[ match ]( context[ match ] );

						// ...a w przeciwnym razie są ustawiane jako atrybuty
						} else {
							this.attr( match, context[ match ] );
						}
					}
				}

				return this;

			// UCHWYT: $(#id)
			} else {
				elem = document.getElementById( match[ 2 ] );

				// Obsługa: Blackberry 4.6
				// gEBID zwraca węzły, których nie ma już w dokumencie (#6963)
				if ( elem && elem.parentNode ) {

					// Wprowadzenie elementu bezpośrednio do obiektu jQuery
					this.length = 1;
					this[ 0 ] = elem;
				}

				this.context = document;
				this.selector = selector;
				return this;
			}

		// UCHWYT: $(expr, $(...))
		} else if ( !context || context.jquery ) {
			return ( context || root ).find( selector );

		// UCHWYT: $(expr, context)
		// (jest to odpowiednik: $(context).find(expr)
		} else {
			return this.constructor( context ).find( selector );
		}

	// UCHWYT: $(DOMElement)
	} else if ( selector.nodeType ) {
		this.context = this[ 0 ] = selector;
		this.length = 1;
		return this;

	// UCHWYT: $(function)
	// Skrót dla zdarzenia gotowości dokumentu
	} else if ( jQuery.isFunction( selector ) ) {
		return root.ready !== undefined ?
			root.ready( selector ) :

			// Natychmiast wykonywane w wypadku braku gotowości
			selector( jQuery );
	}

	if ( selector.selector !== undefined ) {
		this.selector = selector.selector;
		this.context = selector.context;
	}

	return jQuery.makeArray( selector, this );
};
